(define (generate-parenthesis n)
  (define result '())
  (define (backtrack left right current)
    (when (= (string-length current) (* 2 n))
      (set! result (cons current result))
      (void))
    (when (< left n)
      (backtrack (+ left 1) right (string-append current "(")))
    (when (< right left)
      (backtrack left (+ right 1) (string-append current ")"))))
  (backtrack 0 0 "")
  (reverse result))